# 帳票設計書 10-Aliases Report

## 概要

本ドキュメントは、OpenSearchの `_cat/aliases` APIが出力するAliases Reportの帳票設計書である。インデックスエイリアスの一覧をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Aliases Reportは、クラスタに定義されたインデックスエイリアスの一覧を表示する帳票である。エイリアス名、対象インデックス、フィルタの有無、ルーティング設定、書き込みインデックス設定などの情報を出力する。

**業務上の目的・背景**：インデックスエイリアスはOpenSearchにおけるインデックスの抽象化レイヤーであり、ゼロダウンタイムでのインデックス切り替え、複数インデックスの論理的なグルーピング、フィルタリング付きビューの作成に使用される。エイリアスの設定状況を一覧で把握することは、クラスタの論理構成を理解するために不可欠である。

**帳票の利用シーン**：エイリアス設定の確認、インデックス切り替え前後の検証、フィルタ/ルーティング設定の確認、書き込みインデックスの特定に利用される。

**主要な出力内容**：
1. エイリアス名
2. 対象インデックス名
3. フィルタの有無
4. インデックスルーティング設定
5. 検索ルーティング設定
6. 書き込みインデックスフラグ

**帳票の出力タイミング**：ユーザーが `GET /_cat/aliases` または `GET /_cat/aliases/{alias}` エンドポイントにHTTPリクエストを送信した時点で出力される。

**帳票の利用者**：アプリケーション開発者、クラスタ管理者、データエンジニア。

## 帳票種別

一覧表（テキストテーブル形式のエイリアス情報一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Cat エイリアス | `GET /_cat/aliases` | HTTP GETリクエスト |
| - | Cat エイリアス（指定） | `GET /_cat/aliases/{alias}` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

エイリアス数分の行を持つテキストテーブルとしてエイリアス情報を出力する。1つのインデックスに複数のエイリアスがある場合や、1つのエイリアスが複数のインデックスを指している場合、それぞれ別行として出力される。

```
┌───────────────────────────────────────────────────────────┐
│ alias       index       filter  routing.index  routing... │
├───────────────────────────────────────────────────────────┤
│ my-alias    my-index-1  -       -              -          │
│ my-alias    my-index-2  *       -              -          │
│ logs-alias  logs-2024   -       1              1          │
└───────────────────────────────────────────────────────────┘
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | エイリアス |
|----|-------|------|-------------|---------|----------|
| 1 | alias | エイリアス名 | AliasMetadata.alias() | 文字列 | a |
| 2 | index | 対象インデックス名 | Map.Entry key (indexName) | 文字列 | i, idx |
| 3 | filter | フィルタの有無 | AliasMetadata.filteringRequired() | *（あり）/ -（なし） | f, fi |
| 4 | routing.index | インデックスルーティング | AliasMetadata.indexRouting() | 文字列（未設定は「-」） | ri, routingIndex |
| 5 | routing.search | 検索ルーティング | AliasMetadata.searchRouting() | 文字列（未設定は「-」） | rs, routingSearch |
| 6 | is_write_index | 書き込みインデックスフラグ | AliasMetadata.writeIndex() | true/false/- | w, isWriteIndex |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| alias | エイリアス名パターン（カンマ区切り） | No |
| local | ローカルクラスタ状態を使用 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | `s` パラメータで任意指定可能 | 任意 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| GetAliasesResponse | エイリアスメタデータ | GetAliasesRequest |

### データソース別参照項目詳細

#### AliasMetadata

| 参照項目（メソッド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| alias() | alias | 無条件 | - |
| filteringRequired() | filter | 無条件 | true → "*"、false → "-" |
| indexRouting() | routing.index | 無条件 | null/空文字 → "-" |
| searchRouting() | routing.search | 無条件 | null/空文字 → "-" |
| writeIndex() | is_write_index | 無条件 | null → "-"、Boolean.toString() |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| filter | filteringRequired() ? "*" : "-" | なし | フィルタ有無の簡易表示 |
| routing.index | Strings.hasLength(indexRouting()) ? indexRouting() : "-" | なし | 未設定はハイフン |
| routing.search | Strings.hasLength(searchRouting()) ? searchRouting() : "-" | なし | 未設定はハイフン |
| is_write_index | writeIndex() == null ? "-" : writeIndex().toString() | なし | null はハイフン |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/aliases リクエスト受信] --> B[doCatRequest]
    B --> C{aliasパラメータあり?}
    C -->|Yes| D[GetAliasesRequest - エイリアス名指定]
    C -->|No| E[GetAliasesRequest - 全エイリアス]
    D --> F[client.admin.indices.getAliases 実行]
    E --> F
    F --> G[GetAliasesResponse 受信]
    G --> H[buildTable でテーブル構築]
    H --> I[RestTable.buildResponse]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| エイリアスなし | 該当するエイリアスが存在しない場合 | 空のテーブル（行なし） | エイリアス名の確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | エイリアス×インデックスの組み合わせ数（数個～数百） |
| 目標出力時間 | ミリ秒単位（軽量な内部API呼び出し） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- `allowSystemIndexAccessByDefault()` が `true` に設定されている。
- IndicesOptions によるインデックスアクセス制御が適用される。

## 備考

- GetAliasesResponse はインデックス名をキー、AliasMetadata のリストを値とする Map 構造を返す。
- 1つのインデックスに複数のエイリアスがある場合、各エイリアスが個別の行として出力される。
- フィルタの有無は "*" / "-" の簡易表示であり、フィルタの内容自体は表示されない。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | 行98-109: getTableWithHeader() で6カラムの定義 |
| 1-2 | AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | エイリアスメタデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | 行75-89: doCatRequest() で GetAliasesRequest を生成・実行 |

**主要処理フロー**:
1. **行76-78**: alias パラメータの有無で GetAliasesRequest 生成方法を分岐
2. **行79-80**: IndicesOptions と local パラメータ設定
3. **行82**: client.admin().indices().getAliases() 実行

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | 行111-132: buildTable() でエイリアスごとに行を構築 |

**主要処理フロー**:
- **行114-128**: getAliases() のエントリを反復（外側: インデックス名、内側: AliasMetadata）
- **行120**: フィルタの有無判定（filteringRequired() ? "*" : "-"）
- **行121**: indexRouting のnull/空文字チェック
- **行123**: searchRouting のnull/空文字チェック
- **行125**: writeIndex のnullチェック

### プログラム呼び出し階層図

```
AbstractCatAction.prepareRequest()
    |
    +-- RestAliasAction.doCatRequest() [行75]
           |
           +-- GetAliasesRequest 生成 [行76-78]
           +-- client.admin().indices().getAliases() [行82]
                  |
                  +-- buildTable() [行111]
                         |
                         +-- getTableWithHeader() [行98]
                         +-- getAliases() 反復 [行114]
                         +-- AliasMetadata 反復 [行116]
           |
           +-- RestTable.buildResponse() [行86]
```

### データフロー図

```
[入力]                       [処理]                          [出力]

GET /_cat/aliases    --->  GetAliasesRequest            --->  テキストテーブル
GET /_cat/aliases/{a}         |                               (エイリアス数分の行)
                              v
                       GetAliasesResponse
                       (Map<String, List<AliasMetadata>>)
                              |
                              v
                       buildTable() → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestAliasAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` | ソース | Aliases Report メイン処理 |
| AliasMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` | ソース | エイリアスメタデータ |
| GetAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesRequest.java` | ソース | エイリアス取得リクエスト |
| GetAliasesResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/get/GetAliasesResponse.java` | ソース | エイリアス取得レスポンス |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
